<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */

     protected $fillable = [
        'login', 'name', 'email', 'password', 'rolls', 'is_remote',
        'person', 'domain', 'employee', 'customer',
        'login_at', 'last_login_at', 'failed_attempts', 
        'machine_name', 'ip_address', 'user_agent'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'login_at' => 'datetime',
            'last_login_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    
    public function getRoleNameAttribute(): string
{
    return match ($this->rolls) {
        1  => 'ROLE_ROOT_ADMIN',
        2  => 'ROLE_ROOT_VIEWER',
        3  => 'ROLE_ROOT_CUSTOM_VIEWER',
        4  => 'ROLE_DOMAIN_ADMIN',
        5  => 'ROLE_DOMAIN_VIEWER',
        6  => 'ROLE_DOMAIN_CUSTOM_VIEWER',
        7  => 'ROLE_CUSTOMER_ADMIN',
        8  => 'ROLE_CUSTOMER_VIEWER',
        9  => 'ROLE_CUSTOMER_MANAGER',
        10 => 'ROLE_ANNONYMOUS',
        11 => 'ROLE_TESTER',
        default => 'UNKNOWN',
    };
}
}
