<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('login')->unique(); // Remote login field
            $table->string('name');            // Name field
            $table->string('email')->nullable()->unique();  // Email (nullable for remote users)
            $table->string('password')->nullable();  // Password (only for local users)
            $table->integer('rolls');            // Role field
            $table->boolean('is_remote')->default(true);  // Remote user flag (defaults to true)
            
            // Additional fields as per your request:
            $table->integer('person')->nullable();    // Person identifier
            $table->integer('domain')->nullable();    // Domain identifier
            $table->integer('employee')->nullable();  // Employee identifier
            $table->integer('customer')->nullable();  // Customer identifier
            $table->timestamp('login_at')->nullable(); // The time when the user logged in
            $table->timestamp('last_login_at')->nullable(); // The time of the last login
            $table->integer('failed_attempts')->default(0); // Track failed login attempts
            $table->string('machine_name')->nullable();  // Machine name used for login
            $table->string('ip_address', 45)->nullable(); // User's IP address
            $table->text('user_agent')->nullable();     // User's browser user-agent string

            // For the Laravel built-in functionality
            $table->timestamp('email_verified_at')->nullable();
            $table->rememberToken();
            $table->timestamps();
        });

        Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->string('email')->primary();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
        Schema::dropIfExists('password_reset_tokens');
        Schema::dropIfExists('sessions');
    }
};
